# FarmTrack BioSciences Website

A modern, responsive web application for FarmTrack BioSciences - Sustainable Agriculture Solutions provider specializing in biopesticides and organic farming products.

## Features

- Product catalog with detailed information
- Customer order form with Supabase backend
- Email newsletter subscription
- Performance metrics and ROI calculator
- Interactive gallery
- Location map
- FAQ section
- PWA support for mobile installation
- SEO optimized

## Tech Stack

- React 18 with TypeScript
- Vite for fast development and builds
- Tailwind CSS for styling
- Supabase for database and backend
- React Router for navigation
- Recharts for data visualization
- React Helmet Async for SEO

## Getting Started

### Prerequisites

- Node.js 16+ and npm
- A Supabase account and project

### Installation

1. Clone the repository
```bash
git clone <your-repo-url>
cd farmtrack-website
```

2. Install dependencies
```bash
npm install
```

3. Set up environment variables
   - Copy `.env.example` to `.env`
   - Add your Supabase credentials from https://app.supabase.com/project/_/settings/api

```bash
cp .env.example .env
```

Edit `.env` and add:
```
VITE_SUPABASE_URL=your_supabase_project_url
VITE_SUPABASE_ANON_KEY=your_supabase_anon_key
```

4. Start the development server
```bash
npm run dev
```

The site will be available at `http://localhost:5173`

## Building for Production

```bash
npm run build
```

This creates an optimized build in the `dist` folder.

### Preview Production Build

```bash
npm run preview
```

## Deployment

### Deploy to Netlify

1. Push your code to GitHub
2. Connect your repository to Netlify
3. Set environment variables in Netlify dashboard:
   - `VITE_SUPABASE_URL`
   - `VITE_SUPABASE_ANON_KEY`
4. Deploy using the existing `netlify.toml` configuration

### Deploy to Vercel

1. Push your code to GitHub
2. Import your repository in Vercel
3. Set environment variables in Vercel dashboard:
   - `VITE_SUPABASE_URL`
   - `VITE_SUPABASE_ANON_KEY`
4. Deploy using the existing `vercel.json` configuration

### Other Hosting Platforms

The site can be deployed to any static hosting service:
- GitHub Pages
- Cloudflare Pages
- AWS S3 + CloudFront
- Firebase Hosting

Just build the project and upload the `dist` folder contents.

## Supabase Setup

The database schema includes two tables:

1. **orders** - Stores customer product orders
2. **email_subscriptions** - Stores newsletter subscriptions

Migrations are available in the `supabase/migrations` folder. The schema includes:
- Row Level Security (RLS) enabled
- Public insert access for orders and subscriptions
- Authenticated access for admin operations
- Automatic timestamps
- Proper indexing for performance

## Project Structure

```
farmtrack-website/
├── public/           # Static assets
├── src/
│   ├── components/   # React components
│   │   ├── about/    # About page components
│   │   ├── home/     # Homepage components
│   │   ├── layout/   # Layout components (Header, Footer)
│   │   ├── performance/ # Performance page components
│   │   ├── products/ # Product components
│   │   ├── seo/      # SEO components
│   │   └── ui/       # Reusable UI components
│   ├── data/         # Static data files
│   ├── lib/          # Library configurations (Supabase)
│   ├── pages/        # Page components
│   ├── utils/        # Utility functions
│   ├── App.tsx       # Main app component
│   ├── main.tsx      # Entry point
│   └── index.css     # Global styles
├── supabase/
│   └── migrations/   # Database migrations
├── .env              # Environment variables (not in git)
├── .env.example      # Example environment variables
├── netlify.toml      # Netlify configuration
├── vercel.json       # Vercel configuration
└── package.json      # Dependencies and scripts
```

## Environment Variables

All environment variables must be prefixed with `VITE_` to be accessible in the client:

- `VITE_SUPABASE_URL` - Your Supabase project URL
- `VITE_SUPABASE_ANON_KEY` - Your Supabase anonymous key

## Contributing

1. Fork the repository
2. Create a feature branch
3. Make your changes
4. Test thoroughly
5. Submit a pull request

## License

Copyright 2025 FarmTrack BioSciences. All rights reserved.
