// supabase.ts
import { createClient } from '@supabase/supabase-js';

/**
 * FARMTRACK BIOSCIENCES SUPABASE CONFIGURATION
 * ============================================
 * This file configures the Supabase client for database operations.
 * 
 * FEATURES USED:
 * - Real-time database operations
 * - Row Level Security (RLS)
 * - Public access for orders and email subscriptions
 * - Authenticated access for admin operations
 */

const supabaseUrl = import.meta.env.VITE_SUPABASE_URL;
const supabaseAnonKey = import.meta.env.VITE_SUPABASE_ANON_KEY;

if (!supabaseUrl || !supabaseAnonKey) {
  throw new Error('Missing Supabase configuration');
}

export const supabase = createClient(supabaseUrl, supabaseAnonKey);

// OPTIONAL: TypeScript types (you can skip this section if not using TS)
export type OrderFormData = {
  id?: string;
  name: string;
  phone: string;
  location: string;
  product_name: string;
  additional_info?: string;
  created_at?: string;
};

export type EmailSubscriptionData = {
  id?: string;
  email: string;
  subscribed_at?: string;
  is_active?: boolean;
  source?: string;
};
