import React from 'react';
import { Helmet } from 'react-helmet-async';
import { MapPin, Leaf, Droplets, Sun, Shield, TrendingUp, Award } from 'lucide-react';
import SectionTitle from '../components/ui/SectionTitle';
import LLMOptimization from '../components/seo/LLMOptimization';
import { regions } from '../data/mapData';

const MapPage: React.FC = () => {
  const practices = [
    {
      icon: Leaf,
      title: "Sustainable Farming",
      description: "Eco-friendly practices that preserve soil health and biodiversity"
    },
    {
      icon: Droplets,
      title: "Water Conservation",
      description: "Efficient irrigation systems and water management techniques"
    },
    {
      icon: Sun,
      title: "Climate Adaptation",
      description: "Resilient farming methods adapted to changing climate conditions"
    },
    {
      icon: Shield,
      title: "Crop Protection",
      description: "Integrated pest management and organic protection methods"
    }
  ];


  return (
    <>
      <Helmet>
        <title>Farm Locations & Farmer Processes - FarmTrack BioSciences | Regional Impact & Agricultural Practices</title>
        <meta name="description" content="Discover FarmTrack BioSciences' regional presence across Kenya and East Africa. Explore farmer processes, sustainable agricultural practices, and our impact on local farming communities. See how our biopesticides and organic solutions are transforming agriculture in Nairobi, Kiambu, Nakuru, Meru, Kitui, and other key agricultural regions." />
        <meta name="keywords" content="FarmTrack farm locations Kenya, regional farming improvements, farmer processes documentation, agricultural practices Kenya, sustainable farming methods, biopesticide application techniques, crop monitoring processes, soil testing procedures, harvest quality control, farmer training programs, community knowledge sharing, agricultural extension services, farming best practices, organic farming processes, integrated pest management, precision agriculture techniques, climate-smart farming, water conservation methods, soil health management, crop protection strategies, yield optimization processes, post-harvest handling, export quality standards, agricultural cooperatives, farmer field schools, demonstration plots, research trial sites, agricultural innovation hubs, technology adoption centers, rural development projects, food security initiatives, livelihood improvement programs, environmental conservation practices, biodiversity preservation, pollinator protection, beneficial insect conservation, natural enemy preservation, ecosystem balance, habitat creation, landscape management, carbon sequestration, greenhouse gas reduction, climate change adaptation, resilience building, drought management, water scarcity solutions, labor optimization, mechanization adoption, digital agriculture, smart farming technologies, IoT applications, sensor networks, data analytics, decision support systems, mobile applications, e-extension services, information dissemination, knowledge management, capacity building, skill development, entrepreneurship support, value chain development, market linkages, cooperative formation, group dynamics, social capital, community mobilization, participatory approaches, farmer empowerment, gender inclusion, youth engagement, inclusive development, sustainable livelihoods, poverty reduction, income generation, economic empowerment, financial inclusion, credit access, insurance schemes, risk management, business planning, enterprise development, agribusiness promotion, value addition, processing techniques, storage solutions, transportation logistics, supply chain optimization, market intelligence, price discovery, quality assurance, certification processes, standards compliance, regulatory adherence, policy advocacy, institutional strengthening, governance improvement, transparency enhancement, accountability mechanisms, monitoring systems, evaluation frameworks, impact assessment, outcome measurement, result documentation, success stories, case studies, testimonials, farmer feedback, satisfaction surveys, adoption rates, diffusion patterns, scaling strategies, replication models, sustainability indicators, environmental impact, social outcomes, economic returns, cost-benefit analysis, return on investment, profitability analysis, efficiency metrics, productivity measures, performance indicators, benchmarking studies, comparative analysis, trend analysis, longitudinal studies, panel data, cross-sectional surveys, randomized trials, quasi-experiments, observational studies, qualitative research, ethnographic studies, participatory research, action research, collaborative inquiry, co-creation processes, innovation systems, knowledge networks, learning platforms, communities of practice, professional associations, farmer organizations, producer groups, self-help groups, water user associations, forest user groups, watershed committees, village development committees, local institutions, traditional authorities, customary practices, indigenous knowledge, local innovations, farmer innovations, grassroots solutions, bottom-up approaches, top-down interventions, hybrid models, integrated approaches, holistic frameworks, systems thinking, complexity science, adaptive management, iterative learning, continuous improvement, feedback loops, course correction, strategy adjustment, tactical modifications, operational refinements, process optimization, workflow enhancement, efficiency gains, productivity improvements, quality upgrades, standard elevation, benchmark achievement, target attainment, goal realization, objective fulfillment, mission accomplishment, vision materialization, strategy implementation, plan execution, program delivery, project completion, activity implementation, task performance, function execution, role fulfillment, responsibility discharge, duty completion, obligation satisfaction, commitment honoring, promise keeping, agreement adherence, contract compliance, regulation following, law observance, rule adherence, guideline compliance, standard conformity, protocol following, procedure adherence, process compliance, system conformity, framework adherence, model following, template usage, format compliance, structure adherence, organization conformity, arrangement compliance, setup adherence, configuration following, design compliance, architecture conformity, blueprint adherence, plan following, strategy compliance, approach conformity, method adherence, technique following, tool usage, instrument application, equipment utilization, technology deployment, innovation adoption, solution implementation, intervention delivery, service provision, support offering, assistance providing, help giving, aid supplying, resource sharing, knowledge transferring, skill building, capacity developing, capability enhancing, competency improving, proficiency increasing, expertise building, mastery achieving, excellence attaining, quality reaching, standard meeting, benchmark achieving, target hitting, goal reaching, objective attaining, outcome achieving, result delivering, impact creating, change generating, transformation catalyzing, improvement facilitating, development enabling, progress supporting, advancement promoting, growth fostering, expansion encouraging, scaling facilitating, replication enabling, diffusion supporting, adoption promoting, uptake encouraging, utilization facilitating, application enabling, implementation supporting, deployment promoting, installation encouraging, setup facilitating, configuration enabling, customization supporting, adaptation promoting, modification encouraging, adjustment facilitating, refinement enabling, optimization supporting, enhancement promoting, improvement encouraging, upgrade facilitating, advancement enabling, progress supporting, development promoting, growth encouraging, expansion facilitating, scaling enabling, replication supporting, diffusion promoting, spread encouraging, dissemination facilitating, distribution enabling, circulation supporting, transmission promoting, communication encouraging, information sharing, knowledge dissemination, learning facilitation, education provision, training delivery, capacity building, skill development, competency enhancement, proficiency improvement, expertise building, mastery achievement, excellence attainment, quality realization, standard achievement, benchmark attainment, target realization, goal achievement, objective attainment, outcome realization, result achievement, impact creation, change generation, transformation catalysis, improvement facilitation, development enablement, progress support, advancement promotion, growth fostering, expansion encouragement, scaling facilitation, replication enablement, diffusion support, adoption promotion, uptake encouragement, utilization facilitation, application enablement, implementation support, deployment promotion, installation encouragement, setup facilitation, configuration enablement, customization support, adaptation promotion, modification encouragement, adjustment facilitation, refinement enablement, optimization support, enhancement promotion, improvement encouragement, upgrade facilitation, advancement enablement, progress support, development promotion, growth encouragement, expansion facilitation, scaling enablement, replication support, diffusion promotion, spread encouragement, dissemination facilitation, distribution enablement, circulation support, transmission promotion, communication encouragement" />
        <link rel="canonical" href="https://farmtrack.com/map" />
      </Helmet>
      
      <LLMOptimization 
        pageType="map"
        additionalKeywords={[
          'Kenya agricultural impact', 'regional farming improvements', 'county-wise agriculture data',
          'geographical performance metrics', 'East Africa coverage map', 'provincial impact assessment',
          'district level improvements', 'regional success stories', 'geographical distribution',
          'county performance statistics', 'regional adoption rates', 'area coverage maps',
          'impact visualization', 'geographical reach', 'regional testimonials', 'farmer processes',
          'agricultural practices documentation', 'sustainable farming methods', 'biopesticide application',
          'crop monitoring techniques', 'soil testing procedures', 'harvest quality control'
        ]}
      />

      <div className="min-h-screen bg-gray-50 py-12">
        <div className="container mx-auto px-4">
          <SectionTitle 
            title="Farm Locations & Regional Impact" 
            subtitle="Discover FarmTrack's presence across Kenya's agricultural regions and our impact on local farming communities"
          />


          {/* Regions Grid */}
          <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8 mb-16 relative">
            {regions.map((region, index) => (
              <div
                key={index}
                className="relative rounded-xl overflow-hidden hover:shadow-2xl transition-all duration-500 transform hover:scale-105 group"
                style={{
                  boxShadow: '0 10px 25px rgba(0,0,0,0.15)',
                  height: '450px'
                }}
              >
                {/* Background Image */}
                <div 
                  className="absolute inset-0 bg-cover bg-center transition-transform duration-700 group-hover:scale-110"
                  style={{
                    backgroundImage: `url(${region.image})`
                  }}
                />
                
                {/* Overlay */}
                <div className="absolute inset-0 bg-gradient-to-t from-black/80 via-black/40 to-transparent" />
                
                {/* Content */}
                <div className="absolute inset-0 p-6 flex flex-col justify-between text-white">
                  {/* Top Section */}
                  <div>
                    <div className="flex items-center gap-3 mb-3">
                      <div className="w-10 h-10 bg-white/20 backdrop-blur-sm rounded-full flex items-center justify-center">
                        <MapPin className="text-white" size={20} />
                      </div>
                      <h3 className="text-xl font-bold text-white drop-shadow-lg">{region.name}</h3>
                    </div>
                    <p className="text-white/90 mb-2 drop-shadow-md">{region.description}</p>
                    <div className="bg-white/10 backdrop-blur-sm rounded-lg px-3 py-1 inline-block">
                      <p className="text-sm text-white/90">Farms: {region.farms}</p>
                    </div>
                  </div>

                  {/* Bottom Section */}
                  <div className="space-y-4">
                    <div>
                      <h4 className="font-semibold text-white mb-2 drop-shadow-md">Main Crops:</h4>
                      <div className="flex flex-wrap gap-2">
                        {region.crops.map((crop, cropIndex) => (
                          <span
                            key={cropIndex}
                            className="px-3 py-1 bg-white/20 backdrop-blur-sm text-white rounded-full text-sm font-medium border border-white/30"
                          >
                            {crop}
                          </span>
                        ))}
                      </div>
                    </div>
                    
                    {/* Performance Metrics */}
                    <div className="grid grid-cols-2 gap-2">
                      <div className="bg-white/10 backdrop-blur-sm rounded-lg p-2 text-center">
                        <div className="flex items-center justify-center mb-1">
                          <TrendingUp size={16} className="text-white mr-1" />
                        </div>
                        <div className="text-lg font-bold text-white">{region.improvement}%</div>
                        <div className="text-xs text-white/80">Improvement</div>
                      </div>
                      <div className="bg-white/10 backdrop-blur-sm rounded-lg p-2 text-center">
                        <div className="flex items-center justify-center mb-1">
                          <Award size={16} className="text-white mr-1" />
                        </div>
                        <div className="text-lg font-bold text-white">{region.population}M</div>
                        <div className="text-xs text-white/80">Population</div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            ))}
          </div>

          {/* Good Farming Practices Section */}
          <div className="mt-16">
            <SectionTitle 
              title="Good Farming Practices" 
              subtitle="Sustainable methods we promote across all regions"
            />
            
            <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
              {practices.map((practice, index) => (
                <div
                  key={index}
                  className="bg-black border border-gray-700 rounded-xl p-6 text-center hover:shadow-lg transition-all duration-300"
                >
                  <practice.icon className="text-white mx-auto mb-4" size={48} />
                  <h3 className="text-lg font-bold text-white mb-3">{practice.title}</h3>
                  <p className="text-gray-300 text-sm leading-relaxed">{practice.description}</p>
                </div>
              ))}
            </div>
          </div>
        </div>

        {/* Production Offices and Manufacturing Building Section */}
        <div className="mt-16">
          <SectionTitle 
            title="Our Production Offices and Manufacturing Building" 
            subtitle="State-of-the-art facilities ensuring quality and innovation"
          />
          
          <div className="bg-white rounded-2xl shadow-lg overflow-hidden">
            {/* Main Building Image */}
            <div className="h-96 bg-gray-100 relative overflow-hidden">
              <img 
                src="https://i.postimg.cc/wM8yh7wc/Whats-App-Image-2025-08-01-at-17-46-25-da1edc9e.jpg" 
                alt="FarmTrack BioSciences Production Offices and Manufacturing Building" 
                className="w-full h-full object-cover transition-transform duration-700 hover:scale-105"
              />
              <div className="absolute inset-0 bg-gradient-to-t from-black/50 via-transparent to-transparent" />
              <div className="absolute bottom-6 left-6 text-white">
                <h3 className="text-2xl font-bold mb-2">FarmTrack BioSciences Headquarters</h3>
                <p className="text-white/90">NJIRU, Mwiki - Kasarani road, Kasarani Constituency, Kenya</p>
              </div>
            </div>
            
            {/* Facility Information */}
            <div className="p-8">
              <div className="grid grid-cols-1 md:grid-cols-3 gap-8">
                <div className="text-center">
                  <div className="w-16 h-16 bg-primary/10 rounded-full flex items-center justify-center mx-auto mb-4">
                    <MapPin className="text-primary" size={32} />
                  </div>
                  <h4 className="text-lg font-bold text-gray-800 mb-2">Strategic Location</h4>
                  <p className="text-gray-600 text-sm">
                    Located in Nairobi's industrial hub for easy distribution across East Africa
                  </p>
                </div>
                
                <div className="text-center">
                  <div className="w-16 h-16 bg-primary/10 rounded-full flex items-center justify-center mx-auto mb-4">
                    <Shield className="text-primary" size={32} />
                  </div>
                  <h4 className="text-lg font-bold text-gray-800 mb-2">Quality Assurance</h4>
                  <p className="text-gray-600 text-sm">
                    ISO certified manufacturing processes ensuring consistent product quality
                  </p>
                </div>
                
                <div className="text-center">
                  <div className="w-16 h-16 bg-primary/10 rounded-full flex items-center justify-center mx-auto mb-4">
                    <Leaf className="text-primary" size={32} />
                  </div>
                  <h4 className="text-lg font-bold text-gray-800 mb-2">Sustainable Operations</h4>
                  <p className="text-gray-600 text-sm">
                    Eco-friendly manufacturing processes aligned with our environmental mission
                  </p>
                </div>
              </div>
              
              {/* Contact Information */}
              <div className="mt-8 pt-8 border-t border-gray-200">
                <div className="grid grid-cols-1 md:grid-cols-2 gap-6">
                  <div>
                    <h5 className="font-bold text-gray-800 mb-3">Visit Our Facility</h5>
                    <p className="text-gray-600 mb-2">
                      <strong>Address:</strong> NJIRU, Mwiki - Kasarani road, Kasarani Constituency, Kenya
                    </p>
                    <p className="text-gray-600 mb-2">
                      <strong>Phone:</strong> +254 711 495522
                    </p>
                    <p className="text-gray-600">
                      <strong>Email:</strong> farmtrack.consulting@gmail.com
                    </p>
                  </div>
                  
                  <div>
                    <h5 className="font-bold text-gray-800 mb-3">Operating Hours</h5>
                    <p className="text-gray-600 mb-2">
                      <strong>Monday - Friday:</strong> 8:00 AM - 5:00 PM
                    </p>
                    <p className="text-gray-600 mb-2">
                      <strong>Saturday:</strong> 9:00 AM - 1:00 PM
                    </p>
                    <p className="text-gray-600">
                      <strong>Sunday:</strong> Closed
                    </p>
                  </div>
                </div>
                
                {/* Action Buttons */}
                <div className="flex flex-col sm:flex-row gap-4 mt-6">
                  <a
                    href="https://www.google.com/maps/place/Farmtrack+Consulting+Limited/@-1.2454593,36.9380445,17z/"
                    target="_blank"
                    rel="noopener noreferrer"
                    className="btn btn-primary flex items-center justify-center"
                  >
                    <MapPin size={18} className="mr-2" />
                    Get Directions
                  </a>
                  
                  <a
                    href="tel:+254711495522"
                    className="btn btn-outline flex items-center justify-center"
                  >
                    <span className="mr-2">📞</span>
                    Call Us
                  </a>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </>
  );
};

export default MapPage;